/* eslint-disable no-tabs */
/* eslint-disable no-mixed-spaces-and-tabs */
var samplePageObj = {
  // 샘플 타이틀
  title: ' File 타입 컬럼',
  subtitle: 'File Type을 활용한 시트 예제 입니다.',
  // 샘플 설명
  desc: '시트 내에 특정 컬럼의 Type을 File로 지정하시면 해당 컬럼에 파일을 업로드하실 수 있습니다.<br>'
        + '조회된 파일은 서버에서 다운로드 경로 설정시 셀을 클릭하여 다운로드 하실 수 있습니다. <br>'
        + '* 현재 샘플에서는 보안상의 이유로 실제 파일을 저장하실 수 없습니다. 자세한 사용방법은 메뉴얼을 참고해주세요.*',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      HeaderMerge: 6,
      DataMerge: 3,
      FitWidth: 1,
      Export: {
        FilePath: 'https://api.ibleaders.com/ibsheet/v8/samples/customer/files/'
      }
    },
    Cols: [
      {
        Header: '시도명',
        Type: 'Text',
        Name: 'sSido',
        Width: 145,
        Align: 'Center',
        CanEdit: 1,
        ColMerge: 1
      },
      {
        Header: '시군구명',
        Type: 'Text',
        Name: 'sSiGunGu',
        Width: 145,
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '공공도서관',
        Type: 'Int',
        Name: 'publicLb',
        Width: 120,
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '작은도서관',
        Type: 'Int',
        Name: 'smailLb',
        Width: 120,
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '기타',
        Type: 'Int',
        Name: 'excLb',
        Width: 120,
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '도서관 목록',
        Type: 'File',
        Name: 'lblist',
        Width: 300,
        Align: 'Center'
      }
    ],
  },
  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div>'
  + '<button class=\'mgr10\' onclick=\'sampleBtn(this,1)\'>doSave 저장(서버통신 I/O만 확인가능)</button>'
  + '<button class=\'mgr10\' onclick=\'sampleBtn(this,2)\'>ajax 저장(서버통신 I/O만 확인가능)</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
    var url = '';

    if (location.href.indexOf('localhost') > -1) {
      url = '../jsp/samples/customer/upload_save.jsp';
    } else {
      url = 'https://api.ibleaders.com/ibsheet/v8/samples/customer/save_error.jsp';
    }

    if (arguments[0].innerText.match('doSave 저장')) {
      sheet.doSave({
        url: url,
        queryMode: 0,
      });
    } else if (arguments[0].innerText.match('ajax 저장')) {
      var saveData = sheet.getSaveJson({
        saveMode: 2
      });

      $.ajax({
      	  url: url,
      	  data: saveData,
      	  success: function (data) {
      	      var result = data.IO.Result;

      	      // 결과를 시트에 반영한다.
      	      sheet.applySaveResult(result);
      	  }
      });
    }
  },

  // event구문
  event: {
    onAfterSave: function (evtParam) {
      if (evtParam.result < 0) { alert('보안상의 문제로 파일을 저장하실 수 없습니다.'); }
    },
  },

  // data
  data: [
    {
      sSido: '서울특별시',
      sSiGunGu: '강남구',
      publicLb: 13,
      smailLb: 35,
      excLb: 8,
      lblist: 'seoul_gangnamgu_library.xlsx',
      lblistPath: 'https://api.ibleaders.com/ibsheet/v8/samples/customer/files/gangnamgu/',
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '강동구',
      publicLb: 8,
      smailLb: 40,
      excLb: 1,
      lblist: 'seoul_gangdonggu_library.xlsx',
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '강북구',
      publicLb: 7,
      smailLb: 43,
      excLb: 1,
      lblist: 'seoul_gangbukgu_library.xlsx'
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '강서구',
      publicLb: 7,
      smailLb: 43,
      excLb: 1,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '관악구',
      publicLb: 5,
      smailLb: 44,
      excLb: 2,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '광진구',
      publicLb: 5,
      smailLb: 32,
      excLb: 2,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '구로구',
      publicLb: 12,
      smailLb: 70,
      excLb: 1,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '금천구',
      publicLb: 4,
      smailLb: 2,
      excLb: 1,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '노원구',
      publicLb: 11,
      smailLb: 32,
      excLb: 4,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '도봉구',
      publicLb: 6,
      smailLb: 39,
      excLb: 0,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '동대문구',
      publicLb: 4,
      smailLb: 35,
      excLb: 6,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '동작구',
      publicLb: 6,
      smailLb: 40,
      excLb: 4,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '마포구',
      publicLb: 6,
      smailLb: 40,
      excLb: 4,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '서대문구',
      publicLb: 4,
      smailLb: 28,
      excLb: 2,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '서초구',
      publicLb: 7,
      smailLb: 37,
      excLb: 24,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '성동구',
      publicLb: 6,
      smailLb: 25,
      excLb: 0,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '성북구',
      publicLb: 11,
      smailLb: 52,
      excLb: 4,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '송파구',
      publicLb: 12,
      smailLb: 61,
      excLb: 6,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '양천구',
      publicLb: 9,
      smailLb: 41,
      excLb: 1,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '영등포구',
      publicLb: 5,
      smailLb: 37,
      excLb: 13,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '용산구',
      publicLb: 4,
      smailLb: 38,
      excLb: 9,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '은평구',
      publicLb: 8,
      smailLb: 84,
      excLb: 2,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '종로구',
      publicLb: 6,
      smailLb: 21,
      excLb: 22,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '중구',
      publicLb: 4,
      smailLb: 15,
      excLb: 24,
    },
    {
      sSido: '서울특별시',
      sSiGunGu: '중랑구',
      publicLb: 4,
      smailLb: 46,
      excLb: 1,
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
